AddCSLuaFile("cl_init.lua")
AddCSLuaFile("shared.lua")

include("shared.lua");

-- The GM Default thruster init, but without setting it's force to 2000 by default on spawn
function ENT:Initialize()
	self.Entity:SetModel(Model("models/dav0r/thruster.mdl"))
	self.Entity:PhysicsInit(SOLID_VPHYSICS)
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS)
	self.Entity:SetSolid(SOLID_VPHYSICS)
	local phys = self.Entity:GetPhysicsObject()
	if (phys:IsValid()) then
		phys:Wake()
	end
	local max = self.Entity:OBBMaxs()
	local min = self.Entity:OBBMins()
	self.ThrustOffset 	= Vector(0, 0, max.z)
	self.ThrustOffsetR 	= Vector(0, 0, min.z)
	self.ForceAngle		= self.ThrustOffset:GetNormalized() * -1
	self:SetEffect("none") -- We want no effect as default!
	self:SetOffset(self.ThrustOffset)
	self:SetForce(self.InitForce or 2000)
	self.Entity:StartMotionController()
	self:Switch(false)
	self.ActivateOnDamage = false
end

function ENT:KeyValue(k,v)
	if(k == "thrust") then
		-- GM10 and GM9 differs by a certain force-formula.
		self.InitForce = (tonumber(v) or 0)/0.36;
	end
end

--[[
GM10 formula to annihilate a mass by a thruster to make it float:
M	|	F
60	|	1000
120|	2000
240|	4000
... and so on => Linearic
F = M/0.06

GM9 Thruster Formula (no testseries - was linearic too!)
Where gravity = 600
M = F/( Gravity/100)
F = M*( Gravity/100) = M*6
--]]